# Contentful CMS Setup - Step by Step Guide

## Step 1: Create Your Contentful Account

1. **Visit Contentful**: Go to https://www.contentful.com/sign-up/
2. **Sign Up**: Create a free account (no credit card required)
3. **Create Space**: Name it "SAAM Cabins" 
4. **Choose Plan**: Select "Free" plan (perfect for getting started)

## Step 2: Get Your API Credentials

After creating your space:

1. **Go to Settings**: Click the settings icon in the top navigation
2. **API Keys**: Click on "API keys" in the left sidebar
3. **Add API Key**: Click "Add API key" button
4. **Copy Credentials**: You'll need these two values:
   - **Space ID**: Found at the top of the API key page
   - **Content Delivery API - access token**: The long string under "Content Delivery API"

## Step 3: Configure Your Project

1. **Create Environment File**: 
   ```bash
   cp .env.local.example .env.local
   ```

2. **Add Your Credentials** to `.env.local`:
   ```env
   CONTENTFUL_SPACE_ID=your_space_id_here
   CONTENTFUL_ACCESS_TOKEN=your_access_token_here
   ```

## Step 4: Create Content Models in Contentful

### Content Model 1: Company Info
1. **In Contentful**: Go to "Content model" → "Add content type"
2. **Name**: "Company Info" 
3. **Content type ID**: `companyInfo`
4. **Add these fields**:

| Field Name | Field Type | Settings |
|------------|------------|----------|
| Company Name | Text | Required |
| Tagline | Text | Required |
| Description | Long text | Required |
| Phone Number | Text | Required |
| WhatsApp Number | Text | Required |
| Email | Text | Required |
| Address | Long text | Required |
| Working Hours | Text | Required |
| Logo | Media | Single file |
| Hero Image | Media | Single file |

### Content Model 2: Product
1. **Create Content Type**: "Product"
2. **Content type ID**: `product`
3. **Add these fields**:

| Field Name | Field Type | Settings |
|------------|------------|----------|
| Name | Text | Required |
| Slug | Text | Required, Unique |
| Category | Text | Required |
| Short Description | Text | Required |
| Full Description | Rich text | |
| Features | Text | List, Multiple values |
| Specifications | JSON object | |
| Applications | Text | List, Multiple values |
| Images | Media | Multiple files |
| Price | Number | Decimal |
| Is Active | Boolean | Required, Default: true |
| Order | Integer | Required, Default: 1 |

### Content Model 3: Feature
1. **Create Content Type**: "Feature"
2. **Content type ID**: `feature`
3. **Add these fields**:

| Field Name | Field Type | Settings |
|------------|------------|----------|
| Title | Text | Required |
| Description | Text | Required |
| Icon | Text | Required, Help text: "Lucide React icon name" |
| Order | Integer | Required |
| Is Active | Boolean | Required, Default: true |

### Content Model 4: Testimonial
1. **Create Content Type**: "Testimonial"
2. **Content type ID**: `testimonial`
3. **Add these fields**:

| Field Name | Field Type | Settings |
|------------|------------|----------|
| Customer Name | Text | Required |
| Company | Text | Required |
| Position | Text | |
| Content | Long text | Required |
| Rating | Integer | Required, Min: 1, Max: 5 |
| Avatar | Media | Single file |
| Is Active | Boolean | Required, Default: true |
| Order | Integer | Required |

### Content Model 5: Project
1. **Create Content Type**: "Project"
2. **Content type ID**: `project`
3. **Add these fields**:

| Field Name | Field Type | Settings |
|------------|------------|----------|
| Name | Text | Required |
| Slug | Text | Required, Unique |
| Description | Text | Required |
| Client | Text | Required |
| Location | Text | Required |
| Completion Date | Date | Required |
| Category | Text | Required |
| Images | Media | Multiple files |
| Details | Rich text | |
| Is Active | Boolean | Required, Default: true |
| Order | Integer | Required |

## Step 5: Add Sample Content

### Company Info Entry
Create one entry with your company details:
- **Company Name**: "SAAM Cabins"
- **Tagline**: "Premium Porta Cabins & Containers in UAE"
- **Description**: "Leading manufacturer and supplier of high-quality porta cabins, security cabins, and containers across the United Arab Emirates."
- **Phone Number**: "+971 58 201 2073"
- **WhatsApp Number**: "+971 58 201 2073"
- **Email**: "info@saamcabins.com"
- **Address**: "Industrial Area, Sharjah, UAE"
- **Working Hours**: "Sunday - Thursday: 8:00 AM - 6:00 PM"

### Sample Features (Create 6 entries)
1. **Premium Quality** - Icon: "Award" - Description: "ISO certified manufacturing with premium materials"
2. **Fast Delivery** - Icon: "Zap" - Description: "Quick manufacturing and delivery across UAE"
3. **Custom Solutions** - Icon: "Wrench" - Description: "Tailored designs for specific requirements"
4. **Professional Service** - Icon: "Users" - Description: "Expert consultation and support"
5. **Nationwide Coverage** - Icon: "Globe" - Description: "Service across all UAE emirates"
6. **Security & Safety** - Icon: "Shield" - Description: "Enhanced security and safety compliance"

### Sample Products (Create 3 entries)
1. **Security Cabins**
   - Slug: "security-cabin"
   - Category: "Security"
   - Features: ["Bullet-proof glass", "Climate control", "CCTV ready", "Communication systems"]
   - Applications: ["Construction sites", "Industrial facilities", "Government buildings"]

2. **Office Cabins**
   - Slug: "office-cabin" 
   - Category: "Office"
   - Features: ["Professional interiors", "IT infrastructure", "Meeting rooms", "Ergonomic design"]
   - Applications: ["Construction offices", "Remote locations", "Business expansion"]

3. **Toilet Units**
   - Slug: "toilet-units"
   - Category: "Sanitation"
   - Features: ["Water-efficient fixtures", "Ventilation", "Easy maintenance", "Disabled access"]
   - Applications: ["Construction sites", "Events", "Public facilities"]

## Step 6: Activate CMS on Your Website

Run these commands in your terminal:

```bash
# Backup current static homepage
mv src/app/page.tsx src/app/page-static.tsx

# Activate CMS-enabled homepage  
mv src/app/page-cms.tsx src/app/page.tsx

# Test the website
npm run dev
```

## Step 7: Verify Setup

1. **Check your website**: http://localhost:3000
2. **Content should load**: Either from CMS or fallback data
3. **No errors**: Check browser console for any issues

## Icons Reference for Features

Use these icon names in the "Icon" field for features:
- **Award** - Trophy/certificate icon
- **Zap** - Lightning bolt for speed
- **Wrench** - Tool for customization
- **Users** - People for service
- **Globe** - World for coverage  
- **Shield** - Security icon
- **Building2** - Building icon
- **Clock** - Time icon
- **CheckCircle** - Checkmark icon

## Troubleshooting

**Q: Content not showing?**
- Verify API credentials in `.env.local`
- Check that content is Published (not just saved)
- Ensure "Is Active" is set to true

**Q: Images not loading?**
- Make sure images are uploaded and published
- Check image file formats (JPG, PNG, WebP supported)

**Q: Build errors?**
- Run `npm install` to ensure dependencies are installed
- Check that all required fields have content

## Next Steps

Once setup is complete:
1. **Upload real images** for products and company
2. **Add more products** to your catalog  
3. **Collect testimonials** from customers
4. **Create project portfolio** entries
5. **Customize content** as needed

Your website will now be fully CMS-powered! 🎉